<?php

class WPBakeryShortCode_Price_Table extends WPBakeryShortCode {
    protected function content( $atts, $content = null){
        extract( shortcode_atts( array(
            "title" => 'Title',
            "price"     => "15",
            "per"     => "/mo",
            "symbol" => "$",
            "button_text"     => "Button",
            "button_link"     => "",
            "extra_class" => ""
        ), $atts ) );

        $content = wpb_js_remove_wpautop( $content, true );

        $result = '<div class="price-block">
                         <div class="price-price">
                            <h4>'.$title.'</h4>
                         </div>
                         <div class="price-title">
                           <sup>'.$symbol.'</sup>
                              <span>'.$price.'</span>
                                <sub>'.$per.'</sub>
                         </div>
                         '.$content.'
                         <div class="button-style-2">
                           <a href="'.$button_link.'" class="b-md butt-style">'.$button_text.'</a>
                         </div>
                    </div>';

        return $result;
    }
}

vc_map( array(
            "name" => __("Price Table", 'themeton'),
            "description" => __("Prices", 'themeton'),
            "base" => "price_table",
            "class" => "",
            "icon" => "icon-wpb-quickload",
            "category" => __('Themeton', 'themeton'),
            "show_settings_on_create" => true,
            "params" => array(
                array(
                    'type' => 'textfield',
                    "param_name" => "title",
                    "heading" => __("Title", 'themeton'),
                    "value" => 'STARTER',
                    "holder" => "div"
                ),
                array(
                    'type' => 'textfield',
                    "param_name" => "price",
                    "heading" => __("Price", 'themeton'),
                    "value" => '15'
                ),
                array(
                    'type' => 'textfield',
                    "param_name" => "symbol",
                    "heading" => __("Currency", 'themeton'),
                    "value" => '$'
                ),
                array(
                    'type' => 'textfield',
                    "param_name" => "per",
                    "heading" => __("Per?", 'themeton'),
                    "value" => '/mo'
                ),
                array(
                    'type' => 'textarea_html',
                    "param_name" => "content",
                    "heading" => __("Content", 'themeton'),
                    "value" => ''
                ),
                array(
                    'type' => 'textfield',
                    "param_name" => "button_text",
                    "heading" => __("Button text", 'themeton'),
                    "value" => 'SIGN IN'
                ),
                array(
                    'type' => 'textfield',
                    "param_name" => "button_link",
                    "heading" => __("Button Link", 'themeton'),
                    "value" => '#!'
                ),
                array(
                    "type" => "textfield",
                    "param_name" => "extra_class",
                    "heading" => __("Extra Class", 'vc_extend'),
                    "value" => "",
                    "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'vc_extend'),
                )
            )
        ) );